-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.3.13-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             10.1.0.5464
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for rms_db
CREATE DATABASE IF NOT EXISTS `rms_db` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `rms_db`;

-- Dumping structure for table rms_db.allowed_company
CREATE TABLE IF NOT EXISTS `allowed_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_change_request` tinyint(1) NOT NULL,
  `create_change_request_template` tinyint(1) NOT NULL,
  `view_all_change_request` tinyint(1) NOT NULL,
  `approve_cr` tinyint(1) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `company_pivot_id` varchar(255) NOT NULL,
  `group_pivots_id` varchar(255) NOT NULL,
  `id_number_id` varchar(255) NOT NULL,
  `view_all_change_request_template` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `allowed_company_company_pivot_id_group_p_9c823ada_uniq` (`company_pivot_id`,`group_pivots_id`,`id_number_id`),
  KEY `allowed_company_group_pivots_id_3b2e331c_fk_departments_code` (`group_pivots_id`),
  KEY `allowed_company_id_number_id_7c5c7fc8_fk_auth_user_code` (`id_number_id`),
  CONSTRAINT `allowed_company_company_pivot_id_35c7dec7_fk_companies_code` FOREIGN KEY (`company_pivot_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `allowed_company_group_pivots_id_3b2e331c_fk_departments_code` FOREIGN KEY (`group_pivots_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `allowed_company_id_number_id_7c5c7fc8_fk_auth_user_code` FOREIGN KEY (`id_number_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.allowed_company: ~0 rows (approximately)
DELETE FROM `allowed_company`;
/*!40000 ALTER TABLE `allowed_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `allowed_company` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_assets
CREATE TABLE IF NOT EXISTS `ams_assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `asset_type_id` varchar(255) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_assets_asset_type_id_86006562_fk_ams_asset_types_code` (`asset_type_id`),
  KEY `ams_assets_created_by_id_c42686ea_fk_auth_user_code` (`created_by_id`),
  CONSTRAINT `ams_assets_asset_type_id_86006562_fk_ams_asset_types_code` FOREIGN KEY (`asset_type_id`) REFERENCES `ams_asset_types` (`code`),
  CONSTRAINT `ams_assets_created_by_id_c42686ea_fk_auth_user_code` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_assets: ~0 rows (approximately)
DELETE FROM `ams_assets`;
/*!40000 ALTER TABLE `ams_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_assets` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_asset_groups
CREATE TABLE IF NOT EXISTS `ams_asset_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_asset_groups_created_by_id_f439d2b0_fk_auth_user_code` (`created_by_id`),
  CONSTRAINT `ams_asset_groups_created_by_id_f439d2b0_fk_auth_user_code` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_asset_groups: ~0 rows (approximately)
DELETE FROM `ams_asset_groups`;
/*!40000 ALTER TABLE `ams_asset_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_asset_groups` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_asset_stocks
CREATE TABLE IF NOT EXISTS `ams_asset_stocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `unique_identifier` varchar(255) NOT NULL,
  `status` varchar(100) NOT NULL,
  `acquisition_type` varchar(100) NOT NULL,
  `location` varchar(255) NOT NULL,
  `dynamic_field` longtext DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `asset_id` varchar(255) NOT NULL,
  `asset_group_id` varchar(255) NOT NULL,
  `manager_id` varchar(255) NOT NULL,
  `user_client_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `unique_identifier` (`unique_identifier`),
  KEY `ams_asset_stocks_asset_id_c389e1ec_fk_ams_assets_code` (`asset_id`),
  KEY `ams_asset_stocks_asset_group_id_98302ced_fk_ams_asset` (`asset_group_id`),
  KEY `ams_asset_stocks_manager_id_295326b0_fk_auth_user_code` (`manager_id`),
  KEY `ams_asset_stocks_user_client_id_eb5d9b79_fk_auth_user_code` (`user_client_id`),
  CONSTRAINT `ams_asset_stocks_asset_group_id_98302ced_fk_ams_asset` FOREIGN KEY (`asset_group_id`) REFERENCES `ams_asset_groups` (`code`),
  CONSTRAINT `ams_asset_stocks_asset_id_c389e1ec_fk_ams_assets_code` FOREIGN KEY (`asset_id`) REFERENCES `ams_assets` (`code`),
  CONSTRAINT `ams_asset_stocks_manager_id_295326b0_fk_auth_user_code` FOREIGN KEY (`manager_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `ams_asset_stocks_user_client_id_eb5d9b79_fk_auth_user_code` FOREIGN KEY (`user_client_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_asset_stocks: ~0 rows (approximately)
DELETE FROM `ams_asset_stocks`;
/*!40000 ALTER TABLE `ams_asset_stocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_asset_stocks` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_asset_stock_supports
CREATE TABLE IF NOT EXISTS `ams_asset_stock_supports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `start_date` datetime(6) DEFAULT NULL,
  `end_date` datetime(6) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `asset_stock_id` varchar(255) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_asset_stock_supp_asset_stock_id_91b52070_fk_ams_asset` (`asset_stock_id`),
  KEY `ams_asset_stock_supp_created_by_id_f6db18cd_fk_auth_user` (`created_by_id`),
  CONSTRAINT `ams_asset_stock_supp_asset_stock_id_91b52070_fk_ams_asset` FOREIGN KEY (`asset_stock_id`) REFERENCES `ams_asset_stocks` (`code`),
  CONSTRAINT `ams_asset_stock_supp_created_by_id_f6db18cd_fk_auth_user` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_asset_stock_supports: ~0 rows (approximately)
DELETE FROM `ams_asset_stock_supports`;
/*!40000 ALTER TABLE `ams_asset_stock_supports` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_asset_stock_supports` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_asset_types
CREATE TABLE IF NOT EXISTS `ams_asset_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `dynamic_field` longtext DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_asset_types_created_by_id_398dcdf4_fk_auth_user_code` (`created_by_id`),
  CONSTRAINT `ams_asset_types_created_by_id_398dcdf4_fk_auth_user_code` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_asset_types: ~0 rows (approximately)
DELETE FROM `ams_asset_types`;
/*!40000 ALTER TABLE `ams_asset_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_asset_types` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_audit_trail
CREATE TABLE IF NOT EXISTS `ams_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `asset_stock_id` varchar(255) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_audit_trail_asset_stock_id_d7e73d3c_fk_ams_asset_stocks_code` (`asset_stock_id`),
  KEY `ams_audit_trail_created_by_id_82abb031_fk_auth_user_code` (`created_by_id`),
  CONSTRAINT `ams_audit_trail_asset_stock_id_d7e73d3c_fk_ams_asset_stocks_code` FOREIGN KEY (`asset_stock_id`) REFERENCES `ams_asset_stocks` (`code`),
  CONSTRAINT `ams_audit_trail_created_by_id_82abb031_fk_auth_user_code` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_audit_trail: ~0 rows (approximately)
DELETE FROM `ams_audit_trail`;
/*!40000 ALTER TABLE `ams_audit_trail` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_audit_trail` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_privileges
CREATE TABLE IF NOT EXISTS `ams_privileges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ams_user_type` varchar(100) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `department_id` varchar(255) NOT NULL,
  `id_number_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ams_privileges_department_id_id_number_id_fe1d73a7_uniq` (`department_id`,`id_number_id`),
  KEY `ams_privileges_id_number_id_a0407e7e_fk_auth_user_code` (`id_number_id`),
  CONSTRAINT `ams_privileges_department_id_5ddb9507_fk_departments_code` FOREIGN KEY (`department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `ams_privileges_id_number_id_a0407e7e_fk_auth_user_code` FOREIGN KEY (`id_number_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_privileges: ~0 rows (approximately)
DELETE FROM `ams_privileges`;
/*!40000 ALTER TABLE `ams_privileges` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_privileges` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_reports
CREATE TABLE IF NOT EXISTS `ams_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `dynamic_field` longtext DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `asset_stock_id` varchar(255) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  `report_type_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_reports_asset_stock_id_2a7d2b1d_fk_ams_asset_stocks_code` (`asset_stock_id`),
  KEY `ams_reports_created_by_id_e23cfd47_fk_auth_user_code` (`created_by_id`),
  KEY `ams_reports_report_type_id_4ee75e41_fk_ams_report_types_code` (`report_type_id`),
  CONSTRAINT `ams_reports_asset_stock_id_2a7d2b1d_fk_ams_asset_stocks_code` FOREIGN KEY (`asset_stock_id`) REFERENCES `ams_asset_stocks` (`code`),
  CONSTRAINT `ams_reports_created_by_id_e23cfd47_fk_auth_user_code` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `ams_reports_report_type_id_4ee75e41_fk_ams_report_types_code` FOREIGN KEY (`report_type_id`) REFERENCES `ams_report_types` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_reports: ~0 rows (approximately)
DELETE FROM `ams_reports`;
/*!40000 ALTER TABLE `ams_reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_reports` ENABLE KEYS */;

-- Dumping structure for table rms_db.ams_report_types
CREATE TABLE IF NOT EXISTS `ams_report_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `dynamic_field` longtext DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `ams_report_types_created_by_id_1f3af894_fk_auth_user_code` (`created_by_id`),
  CONSTRAINT `ams_report_types_created_by_id_1f3af894_fk_auth_user_code` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.ams_report_types: ~0 rows (approximately)
DELETE FROM `ams_report_types`;
/*!40000 ALTER TABLE `ams_report_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `ams_report_types` ENABLE KEYS */;

-- Dumping structure for table rms_db.applications
CREATE TABLE IF NOT EXISTS `applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `excel_code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.applications: ~3 rows (approximately)
DELETE FROM `applications`;
/*!40000 ALTER TABLE `applications` DISABLE KEYS */;
INSERT INTO `applications` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `excel_code`) VALUES
	(1, '2019-09-23 12:43:33.754098', 'superuser', '2019-09-23 12:43:33.754098', 'superuser', 'APP-20190923-0000001', 'Resource Management System', 'rms'),
	(2, '2019-09-23 12:43:40.512905', 'superuser', '2019-09-23 12:43:40.512905', 'superuser', 'APP-20190923-0000002', 'Change Management System', 'cms'),
	(3, '2019-09-23 12:43:55.957076', 'superuser', '2019-09-23 12:43:55.957076', 'superuser', 'APP-20190923-0000003', 'Asset Management System', 'ams');
/*!40000 ALTER TABLE `applications` ENABLE KEYS */;

-- Dumping structure for table rms_db.attachments
CREATE TABLE IF NOT EXISTS `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.attachments: ~0 rows (approximately)
DELETE FROM `attachments`;
/*!40000 ALTER TABLE `attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.authtoken_token
CREATE TABLE IF NOT EXISTS `authtoken_token` (
  `key` varchar(40) NOT NULL,
  `created` datetime(6) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `authtoken_token_user_id_35299eff_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.authtoken_token: ~0 rows (approximately)
DELETE FROM `authtoken_token`;
/*!40000 ALTER TABLE `authtoken_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `authtoken_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_access_token
CREATE TABLE IF NOT EXISTS `auth_access_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `token` longtext NOT NULL,
  `passcode` varchar(255) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `timeout_at` datetime(6) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_access_token_user_id_c480a680_fk_auth_user_code` (`user_id`),
  CONSTRAINT `auth_access_token_user_id_c480a680_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_access_token: ~0 rows (approximately)
DELETE FROM `auth_access_token`;
/*!40000 ALTER TABLE `auth_access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_access_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group
CREATE TABLE IF NOT EXISTS `auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_group: ~0 rows (approximately)
DELETE FROM `auth_group`;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group_permissions
CREATE TABLE IF NOT EXISTS `auth_group_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_group_permissions_group_id_permission_id_0cd325b0_uniq` (`group_id`,`permission_id`),
  KEY `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_group_permissions_group_id_b120cbf9_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_group_permissions: ~0 rows (approximately)
DELETE FROM `auth_group_permissions`;
/*!40000 ALTER TABLE `auth_group_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_permission
CREATE TABLE IF NOT EXISTS `auth_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content_type_id` int(11) NOT NULL,
  `codename` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_permission_content_type_id_codename_01ab375a_uniq` (`content_type_id`,`codename`),
  CONSTRAINT `auth_permission_content_type_id_2f476e4b_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=585 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_permission: ~432 rows (approximately)
DELETE FROM `auth_permission`;
/*!40000 ALTER TABLE `auth_permission` DISABLE KEYS */;
INSERT INTO `auth_permission` (`id`, `name`, `content_type_id`, `codename`) VALUES
	(1, 'Can add log entry', 1, 'add_logentry'),
	(2, 'Can change log entry', 1, 'change_logentry'),
	(3, 'Can delete log entry', 1, 'delete_logentry'),
	(4, 'Can view log entry', 1, 'view_logentry'),
	(5, 'Can add permission', 2, 'add_permission'),
	(6, 'Can change permission', 2, 'change_permission'),
	(7, 'Can delete permission', 2, 'delete_permission'),
	(8, 'Can view permission', 2, 'view_permission'),
	(9, 'Can add group', 3, 'add_group'),
	(10, 'Can change group', 3, 'change_group'),
	(11, 'Can delete group', 3, 'delete_group'),
	(12, 'Can view group', 3, 'view_group'),
	(13, 'Can add content type', 4, 'add_contenttype'),
	(14, 'Can change content type', 4, 'change_contenttype'),
	(15, 'Can delete content type', 4, 'delete_contenttype'),
	(16, 'Can view content type', 4, 'view_contenttype'),
	(17, 'Can add session', 5, 'add_session'),
	(18, 'Can change session', 5, 'change_session'),
	(19, 'Can delete session', 5, 'delete_session'),
	(20, 'Can view session', 5, 'view_session'),
	(21, 'Can add Token', 6, 'add_token'),
	(22, 'Can change Token', 6, 'change_token'),
	(23, 'Can delete Token', 6, 'delete_token'),
	(24, 'Can view Token', 6, 'view_token'),
	(25, 'Can add user', 7, 'add_user'),
	(26, 'Can change user', 7, 'change_user'),
	(27, 'Can delete user', 7, 'delete_user'),
	(28, 'Can view user', 7, 'view_user'),
	(29, 'Can add application', 8, 'add_application'),
	(30, 'Can change application', 8, 'change_application'),
	(31, 'Can delete application', 8, 'delete_application'),
	(32, 'Can view application', 8, 'view_application'),
	(33, 'Can add attachment', 9, 'add_attachment'),
	(34, 'Can change attachment', 9, 'change_attachment'),
	(35, 'Can delete attachment', 9, 'delete_attachment'),
	(36, 'Can view attachment', 9, 'view_attachment'),
	(37, 'Can add change request form header', 10, 'add_changerequestformheader'),
	(38, 'Can change change request form header', 10, 'change_changerequestformheader'),
	(39, 'Can delete change request form header', 10, 'delete_changerequestformheader'),
	(40, 'Can view change request form header', 10, 'view_changerequestformheader'),
	(41, 'Can add change request history', 11, 'add_changerequesthistory'),
	(42, 'Can change change request history', 11, 'change_changerequesthistory'),
	(43, 'Can delete change request history', 11, 'delete_changerequesthistory'),
	(44, 'Can view change request history', 11, 'view_changerequesthistory'),
	(45, 'Can add change request template header', 12, 'add_changerequesttemplateheader'),
	(46, 'Can change change request template header', 12, 'change_changerequesttemplateheader'),
	(47, 'Can delete change request template header', 12, 'delete_changerequesttemplateheader'),
	(48, 'Can view change request template header', 12, 'view_changerequesttemplateheader'),
	(49, 'Can add company', 13, 'add_company'),
	(50, 'Can change company', 13, 'change_company'),
	(51, 'Can delete company', 13, 'delete_company'),
	(52, 'Can view company', 13, 'view_company'),
	(53, 'Can add email logs', 14, 'add_emaillogs'),
	(54, 'Can change email logs', 14, 'change_emaillogs'),
	(55, 'Can delete email logs', 14, 'delete_emaillogs'),
	(56, 'Can view email logs', 14, 'view_emaillogs'),
	(57, 'Can add entity log', 15, 'add_entitylog'),
	(58, 'Can change entity log', 15, 'change_entitylog'),
	(59, 'Can delete entity log', 15, 'delete_entitylog'),
	(60, 'Can view entity log', 15, 'view_entitylog'),
	(61, 'Can add password reset', 16, 'add_passwordreset'),
	(62, 'Can change password reset', 16, 'change_passwordreset'),
	(63, 'Can delete password reset', 16, 'delete_passwordreset'),
	(64, 'Can view password reset', 16, 'view_passwordreset'),
	(65, 'Can add permission', 17, 'add_permission'),
	(66, 'Can change permission', 17, 'change_permission'),
	(67, 'Can delete permission', 17, 'delete_permission'),
	(68, 'Can view permission', 17, 'view_permission'),
	(69, 'Can add role', 18, 'add_role'),
	(70, 'Can change role', 18, 'change_role'),
	(71, 'Can delete role', 18, 'delete_role'),
	(72, 'Can view role', 18, 'view_role'),
	(73, 'Can add status', 19, 'add_status'),
	(74, 'Can change status', 19, 'change_status'),
	(75, 'Can delete status', 19, 'delete_status'),
	(76, 'Can view status', 19, 'view_status'),
	(77, 'Can add user image', 20, 'add_userimage'),
	(78, 'Can change user image', 20, 'change_userimage'),
	(79, 'Can delete user image', 20, 'delete_userimage'),
	(80, 'Can view user image', 20, 'view_userimage'),
	(81, 'Can add role permission', 21, 'add_rolepermission'),
	(82, 'Can change role permission', 21, 'change_rolepermission'),
	(83, 'Can delete role permission', 21, 'delete_rolepermission'),
	(84, 'Can view role permission', 21, 'view_rolepermission'),
	(85, 'Can add notification', 22, 'add_notification'),
	(86, 'Can change notification', 22, 'change_notification'),
	(87, 'Can delete notification', 22, 'delete_notification'),
	(88, 'Can view notification', 22, 'view_notification'),
	(89, 'Can add module', 23, 'add_module'),
	(90, 'Can change module', 23, 'change_module'),
	(91, 'Can delete module', 23, 'delete_module'),
	(92, 'Can view module', 23, 'view_module'),
	(93, 'Can add department', 24, 'add_department'),
	(94, 'Can change department', 24, 'change_department'),
	(95, 'Can delete department', 24, 'delete_department'),
	(96, 'Can view department', 24, 'view_department'),
	(97, 'Can add change request template stake holders', 25, 'add_changerequesttemplatestakeholders'),
	(98, 'Can change change request template stake holders', 25, 'change_changerequesttemplatestakeholders'),
	(99, 'Can delete change request template stake holders', 25, 'delete_changerequesttemplatestakeholders'),
	(100, 'Can view change request template stake holders', 25, 'view_changerequesttemplatestakeholders'),
	(101, 'Can add change request template details', 26, 'add_changerequesttemplatedetails'),
	(102, 'Can change change request template details', 26, 'change_changerequesttemplatedetails'),
	(103, 'Can delete change request template details', 26, 'delete_changerequesttemplatedetails'),
	(104, 'Can view change request template details', 26, 'view_changerequesttemplatedetails'),
	(105, 'Can add change request template attachments', 27, 'add_changerequesttemplateattachments'),
	(106, 'Can change change request template attachments', 27, 'change_changerequesttemplateattachments'),
	(107, 'Can delete change request template attachments', 27, 'delete_changerequesttemplateattachments'),
	(108, 'Can view change request template attachments', 27, 'view_changerequesttemplateattachments'),
	(109, 'Can add change request template approvers', 28, 'add_changerequesttemplateapprovers'),
	(110, 'Can change change request template approvers', 28, 'change_changerequesttemplateapprovers'),
	(111, 'Can delete change request template approvers', 28, 'delete_changerequesttemplateapprovers'),
	(112, 'Can view change request template approvers', 28, 'view_changerequesttemplateapprovers'),
	(113, 'Can add change request form stake holders', 29, 'add_changerequestformstakeholders'),
	(114, 'Can change change request form stake holders', 29, 'change_changerequestformstakeholders'),
	(115, 'Can delete change request form stake holders', 29, 'delete_changerequestformstakeholders'),
	(116, 'Can view change request form stake holders', 29, 'view_changerequestformstakeholders'),
	(117, 'Can add change request form details', 30, 'add_changerequestformdetails'),
	(118, 'Can change change request form details', 30, 'change_changerequestformdetails'),
	(119, 'Can delete change request form details', 30, 'delete_changerequestformdetails'),
	(120, 'Can view change request form details', 30, 'view_changerequestformdetails'),
	(121, 'Can add change request form attachments', 31, 'add_changerequestformattachments'),
	(122, 'Can change change request form attachments', 31, 'change_changerequestformattachments'),
	(123, 'Can delete change request form attachments', 31, 'delete_changerequestformattachments'),
	(124, 'Can view change request form attachments', 31, 'view_changerequestformattachments'),
	(125, 'Can add change request form approvers', 32, 'add_changerequestformapprovers'),
	(126, 'Can change change request form approvers', 32, 'change_changerequestformapprovers'),
	(127, 'Can delete change request form approvers', 32, 'delete_changerequestformapprovers'),
	(128, 'Can view change request form approvers', 32, 'view_changerequestformapprovers'),
	(129, 'Can add auth token', 33, 'add_authtoken'),
	(130, 'Can change auth token', 33, 'change_authtoken'),
	(131, 'Can delete auth token', 33, 'delete_authtoken'),
	(132, 'Can view auth token', 33, 'view_authtoken'),
	(133, 'Can add allowed company', 34, 'add_allowedcompany'),
	(134, 'Can change allowed company', 34, 'change_allowedcompany'),
	(135, 'Can delete allowed company', 34, 'delete_allowedcompany'),
	(136, 'Can view allowed company', 34, 'view_allowedcompany'),
	(141, 'Can add master attachment', 16, 'add_masterattachment'),
	(142, 'Can change master attachment', 16, 'change_masterattachment'),
	(143, 'Can delete master attachment', 16, 'delete_masterattachment'),
	(144, 'Can view master attachment', 16, 'view_masterattachment'),
	(145, 'Can add notification', 17, 'add_notification'),
	(146, 'Can change notification', 17, 'change_notification'),
	(147, 'Can delete notification', 17, 'delete_notification'),
	(148, 'Can view notification', 17, 'view_notification'),
	(149, 'Can add password reset', 18, 'add_passwordreset'),
	(150, 'Can change password reset', 18, 'change_passwordreset'),
	(151, 'Can delete password reset', 18, 'delete_passwordreset'),
	(152, 'Can view password reset', 18, 'view_passwordreset'),
	(153, 'Can add permission', 19, 'add_permission'),
	(154, 'Can change permission', 19, 'change_permission'),
	(155, 'Can delete permission', 19, 'delete_permission'),
	(156, 'Can view permission', 19, 'view_permission'),
	(157, 'Can add role', 20, 'add_role'),
	(158, 'Can change role', 20, 'change_role'),
	(159, 'Can delete role', 20, 'delete_role'),
	(160, 'Can view role', 20, 'view_role'),
	(161, 'Can add status', 21, 'add_status'),
	(162, 'Can change status', 21, 'change_status'),
	(163, 'Can delete status', 21, 'delete_status'),
	(164, 'Can view status', 21, 'view_status'),
	(165, 'Can add user image', 22, 'add_userimage'),
	(166, 'Can change user image', 22, 'change_userimage'),
	(167, 'Can delete user image', 22, 'delete_userimage'),
	(168, 'Can view user image', 22, 'view_userimage'),
	(169, 'Can add role permission', 23, 'add_rolepermission'),
	(170, 'Can change role permission', 23, 'change_rolepermission'),
	(171, 'Can delete role permission', 23, 'delete_rolepermission'),
	(172, 'Can view role permission', 23, 'view_rolepermission'),
	(173, 'Can add module', 24, 'add_module'),
	(174, 'Can change module', 24, 'change_module'),
	(175, 'Can delete module', 24, 'delete_module'),
	(176, 'Can view module', 24, 'view_module'),
	(177, 'Can add department', 25, 'add_department'),
	(178, 'Can change department', 25, 'change_department'),
	(179, 'Can delete department', 25, 'delete_department'),
	(180, 'Can view department', 25, 'view_department'),
	(181, 'Can add change request template stake holders', 26, 'add_changerequesttemplatestakeholders'),
	(182, 'Can change change request template stake holders', 26, 'change_changerequesttemplatestakeholders'),
	(183, 'Can delete change request template stake holders', 26, 'delete_changerequesttemplatestakeholders'),
	(184, 'Can view change request template stake holders', 26, 'view_changerequesttemplatestakeholders'),
	(185, 'Can add change request template details', 27, 'add_changerequesttemplatedetails'),
	(186, 'Can change change request template details', 27, 'change_changerequesttemplatedetails'),
	(187, 'Can delete change request template details', 27, 'delete_changerequesttemplatedetails'),
	(188, 'Can view change request template details', 27, 'view_changerequesttemplatedetails'),
	(189, 'Can add change request template attachments', 28, 'add_changerequesttemplateattachments'),
	(190, 'Can change change request template attachments', 28, 'change_changerequesttemplateattachments'),
	(191, 'Can delete change request template attachments', 28, 'delete_changerequesttemplateattachments'),
	(192, 'Can view change request template attachments', 28, 'view_changerequesttemplateattachments'),
	(193, 'Can add change request template approvers', 29, 'add_changerequesttemplateapprovers'),
	(194, 'Can change change request template approvers', 29, 'change_changerequesttemplateapprovers'),
	(195, 'Can delete change request template approvers', 29, 'delete_changerequesttemplateapprovers'),
	(196, 'Can view change request template approvers', 29, 'view_changerequesttemplateapprovers'),
	(197, 'Can add change request form stake holders', 30, 'add_changerequestformstakeholders'),
	(198, 'Can change change request form stake holders', 30, 'change_changerequestformstakeholders'),
	(199, 'Can delete change request form stake holders', 30, 'delete_changerequestformstakeholders'),
	(200, 'Can view change request form stake holders', 30, 'view_changerequestformstakeholders'),
	(201, 'Can add change request form details', 31, 'add_changerequestformdetails'),
	(202, 'Can change change request form details', 31, 'change_changerequestformdetails'),
	(203, 'Can delete change request form details', 31, 'delete_changerequestformdetails'),
	(204, 'Can view change request form details', 31, 'view_changerequestformdetails'),
	(205, 'Can add change request form attachments', 32, 'add_changerequestformattachments'),
	(206, 'Can change change request form attachments', 32, 'change_changerequestformattachments'),
	(207, 'Can delete change request form attachments', 32, 'delete_changerequestformattachments'),
	(208, 'Can view change request form attachments', 32, 'view_changerequestformattachments'),
	(209, 'Can add change request form approvers', 33, 'add_changerequestformapprovers'),
	(210, 'Can change change request form approvers', 33, 'change_changerequestformapprovers'),
	(211, 'Can delete change request form approvers', 33, 'delete_changerequestformapprovers'),
	(212, 'Can view change request form approvers', 33, 'view_changerequestformapprovers'),
	(213, 'Can add auth token', 34, 'add_authtoken'),
	(214, 'Can change auth token', 34, 'change_authtoken'),
	(215, 'Can delete auth token', 34, 'delete_authtoken'),
	(216, 'Can view auth token', 34, 'view_authtoken'),
	(217, 'Can add allowed company', 35, 'add_allowedcompany'),
	(218, 'Can change allowed company', 35, 'change_allowedcompany'),
	(219, 'Can delete allowed company', 35, 'delete_allowedcompany'),
	(220, 'Can view allowed company', 35, 'view_allowedcompany'),
	(221, 'Can add reminder trigger', 36, 'add_remindertrigger'),
	(222, 'Can change reminder trigger', 36, 'change_remindertrigger'),
	(223, 'Can delete reminder trigger', 36, 'delete_remindertrigger'),
	(224, 'Can view reminder trigger', 36, 'view_remindertrigger'),
	(225, 'Can add cancel trigger', 37, 'add_canceltrigger'),
	(226, 'Can change cancel trigger', 37, 'change_canceltrigger'),
	(227, 'Can delete cancel trigger', 37, 'delete_canceltrigger'),
	(228, 'Can view cancel trigger', 37, 'view_canceltrigger'),
	(229, 'Can add overdue trigger', 38, 'add_overduetrigger'),
	(230, 'Can change overdue trigger', 38, 'change_overduetrigger'),
	(231, 'Can delete overdue trigger', 38, 'delete_overduetrigger'),
	(232, 'Can view overdue trigger', 38, 'view_overduetrigger'),
	(245, 'Can add reminder trigger', 38, 'add_remindertrigger'),
	(246, 'Can change reminder trigger', 38, 'change_remindertrigger'),
	(247, 'Can delete reminder trigger', 38, 'delete_remindertrigger'),
	(248, 'Can view reminder trigger', 38, 'view_remindertrigger'),
	(249, 'Can add overdue trigger', 36, 'add_overduetrigger'),
	(250, 'Can change overdue trigger', 36, 'change_overduetrigger'),
	(251, 'Can delete overdue trigger', 36, 'delete_overduetrigger'),
	(252, 'Can view overdue trigger', 36, 'view_overduetrigger'),
	(253, 'Can add asset group', 39, 'add_assetgroup'),
	(254, 'Can change asset group', 39, 'change_assetgroup'),
	(255, 'Can delete asset group', 39, 'delete_assetgroup'),
	(256, 'Can view asset group', 39, 'view_assetgroup'),
	(257, 'Can add delegation', 40, 'add_delegation'),
	(258, 'Can change delegation', 40, 'change_delegation'),
	(259, 'Can delete delegation', 40, 'delete_delegation'),
	(260, 'Can view delegation', 40, 'view_delegation'),
	(261, 'Can add user history', 41, 'add_userhistory'),
	(262, 'Can change user history', 41, 'change_userhistory'),
	(263, 'Can delete user history', 41, 'delete_userhistory'),
	(264, 'Can view user history', 41, 'view_userhistory'),
	(265, 'Can add extract transform load', 42, 'add_extracttransformload'),
	(266, 'Can change extract transform load', 42, 'change_extracttransformload'),
	(267, 'Can delete extract transform load', 42, 'delete_extracttransformload'),
	(268, 'Can view extract transform load', 42, 'view_extracttransformload'),
	(405, 'Can add asset group', 9, 'add_assetgroup'),
	(406, 'Can change asset group', 9, 'change_assetgroup'),
	(407, 'Can delete asset group', 9, 'delete_assetgroup'),
	(408, 'Can view asset group', 9, 'view_assetgroup'),
	(409, 'Can add attachment', 10, 'add_attachment'),
	(410, 'Can change attachment', 10, 'change_attachment'),
	(411, 'Can delete attachment', 10, 'delete_attachment'),
	(412, 'Can view attachment', 10, 'view_attachment'),
	(413, 'Can add change request form approvers', 11, 'add_changerequestformapprovers'),
	(414, 'Can change change request form approvers', 11, 'change_changerequestformapprovers'),
	(415, 'Can delete change request form approvers', 11, 'delete_changerequestformapprovers'),
	(416, 'Can view change request form approvers', 11, 'view_changerequestformapprovers'),
	(417, 'Can add change request form header', 12, 'add_changerequestformheader'),
	(418, 'Can change change request form header', 12, 'change_changerequestformheader'),
	(419, 'Can delete change request form header', 12, 'delete_changerequestformheader'),
	(420, 'Can view change request form header', 12, 'view_changerequestformheader'),
	(421, 'Can add change request history', 13, 'add_changerequesthistory'),
	(422, 'Can change change request history', 13, 'change_changerequesthistory'),
	(423, 'Can delete change request history', 13, 'delete_changerequesthistory'),
	(424, 'Can view change request history', 13, 'view_changerequesthistory'),
	(425, 'Can add change request template header', 14, 'add_changerequesttemplateheader'),
	(426, 'Can change change request template header', 14, 'change_changerequesttemplateheader'),
	(427, 'Can delete change request template header', 14, 'delete_changerequesttemplateheader'),
	(428, 'Can view change request template header', 14, 'view_changerequesttemplateheader'),
	(429, 'Can add company', 15, 'add_company'),
	(430, 'Can change company', 15, 'change_company'),
	(431, 'Can delete company', 15, 'delete_company'),
	(432, 'Can view company', 15, 'view_company'),
	(433, 'Can add delegation', 16, 'add_delegation'),
	(434, 'Can change delegation', 16, 'change_delegation'),
	(435, 'Can delete delegation', 16, 'delete_delegation'),
	(436, 'Can view delegation', 16, 'view_delegation'),
	(437, 'Can add email logs', 17, 'add_emaillogs'),
	(438, 'Can change email logs', 17, 'change_emaillogs'),
	(439, 'Can delete email logs', 17, 'delete_emaillogs'),
	(440, 'Can view email logs', 17, 'view_emaillogs'),
	(441, 'Can add entity log', 18, 'add_entitylog'),
	(442, 'Can change entity log', 18, 'change_entitylog'),
	(443, 'Can delete entity log', 18, 'delete_entitylog'),
	(444, 'Can view entity log', 18, 'view_entitylog'),
	(445, 'Can add extract transform load', 19, 'add_extracttransformload'),
	(446, 'Can change extract transform load', 19, 'change_extracttransformload'),
	(447, 'Can delete extract transform load', 19, 'delete_extracttransformload'),
	(448, 'Can view extract transform load', 19, 'view_extracttransformload'),
	(449, 'Can add master attachment', 20, 'add_masterattachment'),
	(450, 'Can change master attachment', 20, 'change_masterattachment'),
	(451, 'Can delete master attachment', 20, 'delete_masterattachment'),
	(452, 'Can view master attachment', 20, 'view_masterattachment'),
	(453, 'Can add notification', 21, 'add_notification'),
	(454, 'Can change notification', 21, 'change_notification'),
	(455, 'Can delete notification', 21, 'delete_notification'),
	(456, 'Can view notification', 21, 'view_notification'),
	(457, 'Can add password reset', 22, 'add_passwordreset'),
	(458, 'Can change password reset', 22, 'change_passwordreset'),
	(459, 'Can delete password reset', 22, 'delete_passwordreset'),
	(460, 'Can view password reset', 22, 'view_passwordreset'),
	(461, 'Can add permission', 23, 'add_permission'),
	(462, 'Can change permission', 23, 'change_permission'),
	(463, 'Can delete permission', 23, 'delete_permission'),
	(464, 'Can view permission', 23, 'view_permission'),
	(465, 'Can add role', 24, 'add_role'),
	(466, 'Can change role', 24, 'change_role'),
	(467, 'Can delete role', 24, 'delete_role'),
	(468, 'Can view role', 24, 'view_role'),
	(469, 'Can add status', 25, 'add_status'),
	(470, 'Can change status', 25, 'change_status'),
	(471, 'Can delete status', 25, 'delete_status'),
	(472, 'Can view status', 25, 'view_status'),
	(473, 'Can add user image', 26, 'add_userimage'),
	(474, 'Can change user image', 26, 'change_userimage'),
	(475, 'Can delete user image', 26, 'delete_userimage'),
	(476, 'Can view user image', 26, 'view_userimage'),
	(477, 'Can add user history', 27, 'add_userhistory'),
	(478, 'Can change user history', 27, 'change_userhistory'),
	(479, 'Can delete user history', 27, 'delete_userhistory'),
	(480, 'Can view user history', 27, 'view_userhistory'),
	(481, 'Can add role permission', 28, 'add_rolepermission'),
	(482, 'Can change role permission', 28, 'change_rolepermission'),
	(483, 'Can delete role permission', 28, 'delete_rolepermission'),
	(484, 'Can view role permission', 28, 'view_rolepermission'),
	(485, 'Can add reminder trigger', 29, 'add_remindertrigger'),
	(486, 'Can change reminder trigger', 29, 'change_remindertrigger'),
	(487, 'Can delete reminder trigger', 29, 'delete_remindertrigger'),
	(488, 'Can view reminder trigger', 29, 'view_remindertrigger'),
	(489, 'Can add overdue trigger', 30, 'add_overduetrigger'),
	(490, 'Can change overdue trigger', 30, 'change_overduetrigger'),
	(491, 'Can delete overdue trigger', 30, 'delete_overduetrigger'),
	(492, 'Can view overdue trigger', 30, 'view_overduetrigger'),
	(493, 'Can add module', 31, 'add_module'),
	(494, 'Can change module', 31, 'change_module'),
	(495, 'Can delete module', 31, 'delete_module'),
	(496, 'Can view module', 31, 'view_module'),
	(497, 'Can add department', 32, 'add_department'),
	(498, 'Can change department', 32, 'change_department'),
	(499, 'Can delete department', 32, 'delete_department'),
	(500, 'Can view department', 32, 'view_department'),
	(501, 'Can add change request template stake holders', 33, 'add_changerequesttemplatestakeholders'),
	(502, 'Can change change request template stake holders', 33, 'change_changerequesttemplatestakeholders'),
	(503, 'Can delete change request template stake holders', 33, 'delete_changerequesttemplatestakeholders'),
	(504, 'Can view change request template stake holders', 33, 'view_changerequesttemplatestakeholders'),
	(505, 'Can add change request template details', 34, 'add_changerequesttemplatedetails'),
	(506, 'Can change change request template details', 34, 'change_changerequesttemplatedetails'),
	(507, 'Can delete change request template details', 34, 'delete_changerequesttemplatedetails'),
	(508, 'Can view change request template details', 34, 'view_changerequesttemplatedetails'),
	(509, 'Can add change request template attachments', 35, 'add_changerequesttemplateattachments'),
	(510, 'Can change change request template attachments', 35, 'change_changerequesttemplateattachments'),
	(511, 'Can delete change request template attachments', 35, 'delete_changerequesttemplateattachments'),
	(512, 'Can view change request template attachments', 35, 'view_changerequesttemplateattachments'),
	(513, 'Can add change request template approvers', 36, 'add_changerequesttemplateapprovers'),
	(514, 'Can change change request template approvers', 36, 'change_changerequesttemplateapprovers'),
	(515, 'Can delete change request template approvers', 36, 'delete_changerequesttemplateapprovers'),
	(516, 'Can view change request template approvers', 36, 'view_changerequesttemplateapprovers'),
	(517, 'Can add change request form stake holders', 37, 'add_changerequestformstakeholders'),
	(518, 'Can change change request form stake holders', 37, 'change_changerequestformstakeholders'),
	(519, 'Can delete change request form stake holders', 37, 'delete_changerequestformstakeholders'),
	(520, 'Can view change request form stake holders', 37, 'view_changerequestformstakeholders'),
	(521, 'Can add change request form details', 38, 'add_changerequestformdetails'),
	(522, 'Can change change request form details', 38, 'change_changerequestformdetails'),
	(523, 'Can delete change request form details', 38, 'delete_changerequestformdetails'),
	(524, 'Can view change request form details', 38, 'view_changerequestformdetails'),
	(525, 'Can add change request form attachments', 39, 'add_changerequestformattachments'),
	(526, 'Can change change request form attachments', 39, 'change_changerequestformattachments'),
	(527, 'Can delete change request form attachments', 39, 'delete_changerequestformattachments'),
	(528, 'Can view change request form attachments', 39, 'view_changerequestformattachments'),
	(529, 'Can add cancel trigger', 40, 'add_canceltrigger'),
	(530, 'Can change cancel trigger', 40, 'change_canceltrigger'),
	(531, 'Can delete cancel trigger', 40, 'delete_canceltrigger'),
	(532, 'Can view cancel trigger', 40, 'view_canceltrigger'),
	(533, 'Can add auth token', 41, 'add_authtoken'),
	(534, 'Can change auth token', 41, 'change_authtoken'),
	(535, 'Can delete auth token', 41, 'delete_authtoken'),
	(536, 'Can view auth token', 41, 'view_authtoken'),
	(537, 'Can add allowed company', 42, 'add_allowedcompany'),
	(538, 'Can change allowed company', 42, 'change_allowedcompany'),
	(539, 'Can delete allowed company', 42, 'delete_allowedcompany'),
	(540, 'Can view allowed company', 42, 'view_allowedcompany'),
	(541, 'Can add change request settings', 43, 'add_changerequestsettings'),
	(542, 'Can change change request settings', 43, 'change_changerequestsettings'),
	(543, 'Can delete change request settings', 43, 'delete_changerequestsettings'),
	(544, 'Can view change request settings', 43, 'view_changerequestsettings'),
	(545, 'Can add ams privilege', 45, 'add_amsprivilege'),
	(546, 'Can change ams privilege', 45, 'change_amsprivilege'),
	(547, 'Can delete ams privilege', 45, 'delete_amsprivilege'),
	(548, 'Can view ams privilege', 45, 'view_amsprivilege'),
	(549, 'Can add ams asset', 46, 'add_amsasset'),
	(550, 'Can change ams asset', 46, 'change_amsasset'),
	(551, 'Can delete ams asset', 46, 'delete_amsasset'),
	(552, 'Can view ams asset', 46, 'view_amsasset'),
	(553, 'Can add ams asset group', 47, 'add_amsassetgroup'),
	(554, 'Can change ams asset group', 47, 'change_amsassetgroup'),
	(555, 'Can delete ams asset group', 47, 'delete_amsassetgroup'),
	(556, 'Can view ams asset group', 47, 'view_amsassetgroup'),
	(557, 'Can add ams asset stock', 48, 'add_amsassetstock'),
	(558, 'Can change ams asset stock', 48, 'change_amsassetstock'),
	(559, 'Can delete ams asset stock', 48, 'delete_amsassetstock'),
	(560, 'Can view ams asset stock', 48, 'view_amsassetstock'),
	(561, 'Can add ams asset stock support', 49, 'add_amsassetstocksupport'),
	(562, 'Can change ams asset stock support', 49, 'change_amsassetstocksupport'),
	(563, 'Can delete ams asset stock support', 49, 'delete_amsassetstocksupport'),
	(564, 'Can view ams asset stock support', 49, 'view_amsassetstocksupport'),
	(565, 'Can add ams asset type', 50, 'add_amsassettype'),
	(566, 'Can change ams asset type', 50, 'change_amsassettype'),
	(567, 'Can delete ams asset type', 50, 'delete_amsassettype'),
	(568, 'Can view ams asset type', 50, 'view_amsassettype'),
	(569, 'Can add ams audit trail', 51, 'add_amsaudittrail'),
	(570, 'Can change ams audit trail', 51, 'change_amsaudittrail'),
	(571, 'Can delete ams audit trail', 51, 'delete_amsaudittrail'),
	(572, 'Can view ams audit trail', 51, 'view_amsaudittrail'),
	(573, 'Can add ams report', 52, 'add_amsreport'),
	(574, 'Can change ams report', 52, 'change_amsreport'),
	(575, 'Can delete ams report', 52, 'delete_amsreport'),
	(576, 'Can view ams report', 52, 'view_amsreport'),
	(577, 'Can add ams report type', 53, 'add_amsreporttype'),
	(578, 'Can change ams report type', 53, 'change_amsreporttype'),
	(579, 'Can delete ams report type', 53, 'delete_amsreporttype'),
	(580, 'Can view ams report type', 53, 'view_amsreporttype'),
	(581, 'Can add change request form assets', 54, 'add_changerequestformassets'),
	(582, 'Can change change request form assets', 54, 'change_changerequestformassets'),
	(583, 'Can delete change request form assets', 54, 'delete_changerequestformassets'),
	(584, 'Can view change request form assets', 54, 'view_changerequestformassets');
/*!40000 ALTER TABLE `auth_permission` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user
CREATE TABLE IF NOT EXISTS `auth_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_login` datetime(6) DEFAULT NULL,
  `is_superuser` tinyint(1) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(150) NOT NULL,
  `is_staff` tinyint(1) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `date_joined` datetime(6) NOT NULL,
  `user_type` varchar(100) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `contact_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `default_app_id` varchar(255) DEFAULT NULL,
  `department_id` varchar(255) DEFAULT NULL,
  `doa_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `username` (`username`),
  KEY `auth_user_default_app_id_410ec732_fk_applications_code` (`default_app_id`),
  KEY `auth_user_department_id_ff5fa3db_fk_departments_code` (`department_id`),
  KEY `auth_user_doa_id_5076b369_fk_auth_user_code` (`doa_id`),
  CONSTRAINT `auth_user_default_app_id_410ec732_fk_applications_code` FOREIGN KEY (`default_app_id`) REFERENCES `applications` (`code`),
  CONSTRAINT `auth_user_department_id_ff5fa3db_fk_departments_code` FOREIGN KEY (`department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `auth_user_doa_id_5076b369_fk_auth_user_code` FOREIGN KEY (`doa_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user: ~1 rows (approximately)
DELETE FROM `auth_user`;
/*!40000 ALTER TABLE `auth_user` DISABLE KEYS */;
INSERT INTO `auth_user` (`id`, `last_login`, `is_superuser`, `first_name`, `last_name`, `is_staff`, `is_active`, `date_joined`, `user_type`, `code`, `name`, `username`, `password`, `contact_no`, `email`, `default_app_id`, `department_id`, `doa_id`) VALUES
	(1, '2020-01-13 21:50:01.985562', 1, '', '', 1, 1, '2019-09-23 12:42:37.938304', 'SU', 'USER-20190923-0000001', '', 'superuser', 'pbkdf2_sha256$150000$YLmqqWBQGsJG$r4NYkY05q1zlmgzh106ejBbzd0NY00YEfylllyVQyk0=', NULL, 'jeffrey@tirsolutions.com', 'APP-20190923-0000001', 'DEPARTMENT-20190923-0000001', NULL);
/*!40000 ALTER TABLE `auth_user` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_application
CREATE TABLE IF NOT EXISTS `auth_user_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_application_user_id_application_id_4d89d44a_uniq` (`user_id`,`application_id`),
  KEY `auth_user_application_application_id_5c17d611_fk_applications_id` (`application_id`),
  CONSTRAINT `auth_user_application_application_id_5c17d611_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`),
  CONSTRAINT `auth_user_application_user_id_7b07e391_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_application: ~3 rows (approximately)
DELETE FROM `auth_user_application`;
/*!40000 ALTER TABLE `auth_user_application` DISABLE KEYS */;
INSERT INTO `auth_user_application` (`id`, `user_id`, `application_id`) VALUES
	(1, 1, 1),
	(2, 1, 2),
	(3, 1, 3);
/*!40000 ALTER TABLE `auth_user_application` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_groups
CREATE TABLE IF NOT EXISTS `auth_user_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_groups_user_id_group_id_94350c0c_uniq` (`user_id`,`group_id`),
  KEY `auth_user_groups_group_id_97559544_fk_auth_group_id` (`group_id`),
  CONSTRAINT `auth_user_groups_group_id_97559544_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`),
  CONSTRAINT `auth_user_groups_user_id_6a12ed8b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_groups: ~0 rows (approximately)
DELETE FROM `auth_user_groups`;
/*!40000 ALTER TABLE `auth_user_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_groups` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_images
CREATE TABLE IF NOT EXISTS `auth_user_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_user_images_user_id_7c29985d_fk_auth_user_code` (`user_id`),
  CONSTRAINT `auth_user_images_user_id_7c29985d_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_images: ~0 rows (approximately)
DELETE FROM `auth_user_images`;
/*!40000 ALTER TABLE `auth_user_images` DISABLE KEYS */;
INSERT INTO `auth_user_images` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `name`, `image`, `is_primary`, `user_id`) VALUES
	(5, '2020-02-21 18:14:44.307326', 'superuser', '2020-02-21 18:14:44.307375', 'superuser', '_profile_pic.png', 'user_images/_profile_pic.png', 1, 'USER-20190923-0000001');
/*!40000 ALTER TABLE `auth_user_images` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_user_permissions
CREATE TABLE IF NOT EXISTS `auth_user_user_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_user_permissions_user_id_permission_id_14a6b632_uniq` (`user_id`,`permission_id`),
  KEY `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_user_permissions: ~0 rows (approximately)
DELETE FROM `auth_user_user_permissions`;
/*!40000 ALTER TABLE `auth_user_user_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_user_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_approvers
CREATE TABLE IF NOT EXISTS `change_request_form_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `action_date` datetime(6) DEFAULT NULL,
  `date_sent` datetime(6) DEFAULT NULL,
  `is_action` tinyint(1) NOT NULL,
  `delegation_id` varchar(255) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_approver_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__delegation_id_5eb27a6e_fk_delegatio` (`delegation_id`),
  KEY `change_request_form__form_code_id_5dfe5c56_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` (`tmp_approver_id`),
  KEY `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` (`user_id`),
  CONSTRAINT `change_request_form__delegation_id_5eb27a6e_fk_delegatio` FOREIGN KEY (`delegation_id`) REFERENCES `delegations` (`code`),
  CONSTRAINT `change_request_form__form_code_id_5dfe5c56_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` FOREIGN KEY (`tmp_approver_id`) REFERENCES `change_request_template_approvers` (`code`),
  CONSTRAINT `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_approvers: ~0 rows (approximately)
DELETE FROM `change_request_form_approvers`;
/*!40000 ALTER TABLE `change_request_form_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_assets
CREATE TABLE IF NOT EXISTS `change_request_form_assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `created` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `asset_stock_id` varchar(255) NOT NULL,
  `created_by_id` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__asset_stock_id_63868f18_fk_ams_asset` (`asset_stock_id`),
  KEY `change_request_form__created_by_id_9357a7e2_fk_auth_user` (`created_by_id`),
  KEY `change_request_form__form_code_id_7a4150f2_fk_change_re` (`form_code_id`),
  CONSTRAINT `change_request_form__asset_stock_id_63868f18_fk_ams_asset` FOREIGN KEY (`asset_stock_id`) REFERENCES `ams_asset_stocks` (`code`),
  CONSTRAINT `change_request_form__created_by_id_9357a7e2_fk_auth_user` FOREIGN KEY (`created_by_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__form_code_id_7a4150f2_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_assets: ~0 rows (approximately)
DELETE FROM `change_request_form_assets`;
/*!40000 ALTER TABLE `change_request_form_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_assets` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_attachments
CREATE TABLE IF NOT EXISTS `change_request_form_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `file_upload_id` int(11) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__file_upload_id_03af7dd6_fk_master_at` (`file_upload_id`),
  KEY `change_request_form__form_code_id_6f991ff9_fk_change_re` (`form_code_id`),
  KEY `change_request_form__uploaded_by_id_3187c462_fk_auth_user` (`uploaded_by_id`),
  CONSTRAINT `change_request_form__file_upload_id_03af7dd6_fk_master_at` FOREIGN KEY (`file_upload_id`) REFERENCES `master_attachments` (`id`),
  CONSTRAINT `change_request_form__form_code_id_6f991ff9_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__uploaded_by_id_3187c462_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_attachments: ~0 rows (approximately)
DELETE FROM `change_request_form_attachments`;
/*!40000 ALTER TABLE `change_request_form_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_details
CREATE TABLE IF NOT EXISTS `change_request_form_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext DEFAULT NULL,
  `field_ref` longtext DEFAULT NULL,
  `field_val` longtext DEFAULT NULL,
  `field_props` longtext DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_b66d4e40_fk_change_re` (`form_code_id`),
  CONSTRAINT `change_request_form__form_code_id_b66d4e40_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_details: ~0 rows (approximately)
DELETE FROM `change_request_form_details`;
/*!40000 ALTER TABLE `change_request_form_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_headers
CREATE TABLE IF NOT EXISTS `change_request_form_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `form_code` varchar(255) NOT NULL,
  `cancel_date` datetime(6) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_target_date` datetime(6) DEFAULT NULL,
  `requested_by_department_id` varchar(255) NOT NULL,
  `requested_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_code` (`form_code`),
  KEY `change_request_form__requested_by_departm_af6aa045_fk_departmen` (`requested_by_department_id`),
  KEY `change_request_form__requested_by_user_id_3287070c_fk_auth_user` (`requested_by_user_id`),
  KEY `change_request_form__requested_to_company_33982877_fk_companies` (`requested_to_company_id`),
  KEY `change_request_form__requested_to_departm_c5d594cd_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` (`requested_to_user_id`),
  KEY `change_request_form__template_no_id_20abd55c_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_form__requested_by_departm_af6aa045_fk_departmen` FOREIGN KEY (`requested_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_by_user_id_3287070c_fk_auth_user` FOREIGN KEY (`requested_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__requested_to_company_33982877_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_form__requested_to_departm_c5d594cd_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__template_no_id_20abd55c_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_headers: ~0 rows (approximately)
DELETE FROM `change_request_form_headers`;
/*!40000 ALTER TABLE `change_request_form_headers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_form_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `date_added` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_350d3c3d_fk_change_re` (`form_code_id`),
  KEY `change_request_form__user_id_378bdf3e_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_form__form_code_id_350d3c3d_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__user_id_378bdf3e_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_stakeholders: ~0 rows (approximately)
DELETE FROM `change_request_form_stakeholders`;
/*!40000 ALTER TABLE `change_request_form_stakeholders` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_history
CREATE TABLE IF NOT EXISTS `change_request_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `batch_no` varchar(255) DEFAULT NULL,
  `main_action` varchar(255) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `fromValue` longtext DEFAULT NULL,
  `toValue` longtext DEFAULT NULL,
  `requested_to_template_id` varchar(255) DEFAULT NULL,
  `template_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_history: ~0 rows (approximately)
DELETE FROM `change_request_history`;
/*!40000 ALTER TABLE `change_request_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_history` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_settings
CREATE TABLE IF NOT EXISTS `change_request_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `behalf_approved` tinyint(1) NOT NULL,
  `behalf_accepted` tinyint(1) NOT NULL,
  `behalf_rejected` tinyint(1) NOT NULL,
  `behalf_implemented` tinyint(1) NOT NULL,
  `behalf_completed` tinyint(1) NOT NULL,
  `created` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `active_user_id` varchar(255) NOT NULL,
  `behalf_user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `change_request_settings_active_user_id_behalf_us_bd54037f_uniq` (`active_user_id`,`behalf_user_id`),
  KEY `change_request_setti_behalf_user_id_80cdf53c_fk_auth_user` (`behalf_user_id`),
  CONSTRAINT `change_request_setti_active_user_id_b24f126d_fk_auth_user` FOREIGN KEY (`active_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_setti_behalf_user_id_80cdf53c_fk_auth_user` FOREIGN KEY (`behalf_user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_settings: ~0 rows (approximately)
DELETE FROM `change_request_settings`;
/*!40000 ALTER TABLE `change_request_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_settings` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_approvers
CREATE TABLE IF NOT EXISTS `change_request_template_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `company_id` varchar(255) DEFAULT NULL,
  `delegation_id` varchar(255) DEFAULT NULL,
  `department_id` varchar(255) DEFAULT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_company_id_1e4b84f6_fk_companies` (`company_id`),
  KEY `change_request_templ_delegation_id_84669e59_fk_delegatio` (`delegation_id`),
  KEY `change_request_templ_department_id_15774369_fk_departmen` (`department_id`),
  KEY `change_request_templ_template_no_id_fba2afd7_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_958c925a_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_company_id_1e4b84f6_fk_companies` FOREIGN KEY (`company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_templ_delegation_id_84669e59_fk_delegatio` FOREIGN KEY (`delegation_id`) REFERENCES `delegations` (`code`),
  CONSTRAINT `change_request_templ_department_id_15774369_fk_departmen` FOREIGN KEY (`department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_template_no_id_fba2afd7_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_user_id_958c925a_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_approvers: ~0 rows (approximately)
DELETE FROM `change_request_template_approvers`;
/*!40000 ALTER TABLE `change_request_template_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_attachments
CREATE TABLE IF NOT EXISTS `change_request_template_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `file_upload_id` int(11) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_file_upload_id_8ac162e7_fk_master_at` (`file_upload_id`),
  KEY `change_request_templ_template_no_id_d0247a80_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` (`uploaded_by_id`),
  CONSTRAINT `change_request_templ_file_upload_id_8ac162e7_fk_master_at` FOREIGN KEY (`file_upload_id`) REFERENCES `master_attachments` (`id`),
  CONSTRAINT `change_request_templ_template_no_id_d0247a80_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_attachments: ~1 rows (approximately)
DELETE FROM `change_request_template_attachments`;
/*!40000 ALTER TABLE `change_request_template_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_details
CREATE TABLE IF NOT EXISTS `change_request_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext DEFAULT NULL,
  `field_ref` longtext DEFAULT NULL,
  `field_val` longtext DEFAULT NULL,
  `field_props` longtext DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d2ba31c2_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_templ_template_no_id_d2ba31c2_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_details: ~0 rows (approximately)
DELETE FROM `change_request_template_details`;
/*!40000 ALTER TABLE `change_request_template_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_headers
CREATE TABLE IF NOT EXISTS `change_request_template_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_priority` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `template_no` varchar(255) NOT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_target_date` int(11) NOT NULL,
  `created_by_department_id` varchar(255) NOT NULL,
  `created_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_no` (`template_no`),
  UNIQUE KEY `requested_to_template_id` (`requested_to_template_id`),
  KEY `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` (`created_by_department_id`),
  KEY `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` (`created_by_user_id`),
  KEY `change_request_templ_requested_to_company_1063b954_fk_companies` (`requested_to_company_id`),
  KEY `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` (`requested_to_user_id`),
  CONSTRAINT `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` FOREIGN KEY (`created_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` FOREIGN KEY (`created_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_requested_to_company_1063b954_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_headers: ~0 rows (approximately)
DELETE FROM `change_request_template_headers`;
/*!40000 ALTER TABLE `change_request_template_headers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_template_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_31bc8d14_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_63128227_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_template_no_id_31bc8d14_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_user_id_63128227_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_stakeholders: ~0 rows (approximately)
DELETE FROM `change_request_template_stakeholders`;
/*!40000 ALTER TABLE `change_request_template_stakeholders` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.companies
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `contact_details` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.companies: ~2 rows (approximately)
DELETE FROM `companies`;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `contact_details`) VALUES
	(1, '2019-09-23 12:45:31.058709', 'superuser', '2019-10-01 18:10:40.098534', 'superuser', 'COMPANY-20190923-0000001', 'Oneberry Technologies Pte Ltd', '2152509');
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;

-- Dumping structure for table rms_db.delegations
CREATE TABLE IF NOT EXISTS `delegations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.delegations: ~6 rows (approximately)
DELETE FROM `delegations`;
/*!40000 ALTER TABLE `delegations` DISABLE KEYS */;
INSERT INTO `delegations` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`) VALUES
	(1, '2019-11-19 17:46:08.984731', 'superuser', '2019-11-19 17:46:08.984731', 'superuser', 'DELEGATION-20191119-0000001', 'Requestor'),
	(2, '2019-11-19 17:46:18.010437', 'superuser', '2019-11-19 17:46:18.010437', 'superuser', 'DELEGATION-20191119-0000002', 'Vendor/Implementor'),
	(3, '2019-11-19 17:46:26.168693', 'superuser', '2019-11-22 10:03:40.605242', 'superuser', 'DELEGATION-20191119-0000003', 'Head of Department'),
	(4, '2019-11-19 17:46:34.020753', 'superuser', '2019-11-19 17:46:34.020753', 'superuser', 'DELEGATION-20191119-0000004', 'SD/OD'),
	(5, '2019-11-19 17:46:41.461203', 'superuser', '2019-11-19 17:46:41.462205', 'superuser', 'DELEGATION-20191119-0000005', 'Change Control Board'),
	(6, '2019-11-19 17:46:49.472397', 'superuser', '2019-11-19 17:46:49.472397', 'superuser', 'DELEGATION-20191119-0000006', 'Approver');
/*!40000 ALTER TABLE `delegations` ENABLE KEYS */;

-- Dumping structure for table rms_db.departments
CREATE TABLE IF NOT EXISTS `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `departments_company_id_name_d90ac127_uniq` (`company_id`,`name`),
  CONSTRAINT `departments_company_id_0d17e9ca_fk_companies_code` FOREIGN KEY (`company_id`) REFERENCES `companies` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.departments: ~1 rows (approximately)
DELETE FROM `departments`;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `company_id`) VALUES
	(1, '2019-09-23 12:45:52.531178', 'superuser', '2019-10-01 18:12:27.956536', 'superuser', 'DEPARTMENT-20190923-0000001', 'Super User', 'COMPANY-20190923-0000001');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;

-- Dumping structure for table rms_db.departments_delegation
CREATE TABLE IF NOT EXISTS `departments_delegation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_id` int(11) NOT NULL,
  `delegation_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `departments_delegation_department_id_delegation_id_2d268fd3_uniq` (`department_id`,`delegation_id`),
  KEY `departments_delegation_delegation_id_e2299803_fk_delegations_id` (`delegation_id`),
  CONSTRAINT `departments_delegation_delegation_id_e2299803_fk_delegations_id` FOREIGN KEY (`delegation_id`) REFERENCES `delegations` (`id`),
  CONSTRAINT `departments_delegation_department_id_a2fbe6fd_fk_departments_id` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.departments_delegation: ~0 rows (approximately)
DELETE FROM `departments_delegation`;
/*!40000 ALTER TABLE `departments_delegation` DISABLE KEYS */;
/*!40000 ALTER TABLE `departments_delegation` ENABLE KEYS */;

-- Dumping structure for table rms_db.email_logs
CREATE TABLE IF NOT EXISTS `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `template` varchar(255) NOT NULL,
  `recipients` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `is_sent` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.email_logs: ~0 rows (approximately)
DELETE FROM `email_logs`;
/*!40000 ALTER TABLE `email_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `email_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.entity_logs
CREATE TABLE IF NOT EXISTS `entity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `row_id` int(11) NOT NULL,
  `fromValue` longtext DEFAULT NULL,
  `toValue` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.entity_logs: ~0 rows (approximately)
DELETE FROM `entity_logs`;
/*!40000 ALTER TABLE `entity_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `entity_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.extract_transform_load
CREATE TABLE IF NOT EXISTS `extract_transform_load` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `model_type` varchar(100) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.extract_transform_load: ~0 rows (approximately)
DELETE FROM `extract_transform_load`;
/*!40000 ALTER TABLE `extract_transform_load` DISABLE KEYS */;
/*!40000 ALTER TABLE `extract_transform_load` ENABLE KEYS */;

-- Dumping structure for table rms_db.extract_transform_load_user_history
CREATE TABLE IF NOT EXISTS `extract_transform_load_user_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `sent` tinyint(1) NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  `file_name_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `extract_transform_lo_file_name_id_ab7ecf60_fk_extract_t` (`file_name_id`),
  CONSTRAINT `extract_transform_lo_file_name_id_ab7ecf60_fk_extract_t` FOREIGN KEY (`file_name_id`) REFERENCES `extract_transform_load` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.extract_transform_load_user_history: ~0 rows (approximately)
DELETE FROM `extract_transform_load_user_history`;
/*!40000 ALTER TABLE `extract_transform_load_user_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `extract_transform_load_user_history` ENABLE KEYS */;

-- Dumping structure for table rms_db.master_attachments
CREATE TABLE IF NOT EXISTS `master_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(100) DEFAULT NULL,
  `attch_ref` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.master_attachments: ~0 rows (approximately)
DELETE FROM `master_attachments`;
/*!40000 ALTER TABLE `master_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `master_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.modules
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `sort_id` int(11) NOT NULL,
  `component` varchar(255) DEFAULT NULL,
  `application_id` varchar(255) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `modules_application_id_f285bf5b_fk_applications_code` (`application_id`),
  KEY `modules_parent_id_c1d497fb_fk_modules_id` (`parent_id`),
  CONSTRAINT `modules_application_id_f285bf5b_fk_applications_code` FOREIGN KEY (`application_id`) REFERENCES `applications` (`code`),
  CONSTRAINT `modules_parent_id_c1d497fb_fk_modules_id` FOREIGN KEY (`parent_id`) REFERENCES `modules` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.modules: ~15 rows (approximately)
DELETE FROM `modules`;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `sort_id`, `component`, `application_id`, `parent_id`) VALUES
	(1, '2019-09-27 12:49:27.795897', 'superuser', '2019-09-27 12:49:27.795897', 'superuser', 'MODULE-20190927-0000001', 'Application Management', 1, 'rms/application-management', 'APP-20190923-0000001', NULL),
	(2, '2019-09-27 12:49:31.756321', 'superuser', '2019-09-27 13:00:57.280102', 'superuser', 'MODULE-20190927-0000002', 'Company Management', 6, 'rms/company-management', 'APP-20190923-0000001', NULL),
	(3, '2019-09-27 12:49:49.528430', 'superuser', '2019-09-27 13:00:18.423200', 'superuser', 'MODULE-20190927-0000003', 'Department Management', 10, 'rms/department-management', 'APP-20190923-0000001', NULL),
	(4, '2019-09-27 12:49:57.378955', 'superuser', '2019-09-27 12:58:07.634481', 'superuser', 'MODULE-20190927-0000004', 'Module Management', 11, 'rms/module-management', 'APP-20190923-0000001', NULL),
	(5, '2019-09-27 12:50:01.383432', 'superuser', '2019-09-30 14:37:53.210860', 'superuser', 'MODULE-20190927-0000005', 'User Management', 12, 'rms/user-management', 'APP-20190923-0000001', NULL),
	(6, '2019-09-27 12:50:15.910699', 'superuser', '2019-09-27 19:04:53.805099', 'superuser', 'MODULE-20190927-0000006', 'Change Request Template', 7, 'cms/change-request/template', 'APP-20190923-0000002', NULL),
	(10, '2019-09-28 12:28:20.174483', 'superuser', '2019-09-30 14:38:38.604217', 'superuser', 'MODULE-20190928-0000010', 'Change Request Form', 6, 'cms/change-request/form', 'APP-20190923-0000002', NULL),
	(11, '2019-09-30 17:15:33.022534', 'superuser', '2019-09-30 17:15:33.022578', 'superuser', 'MODULE-20190930-0000011', 'Notification', 1, 'cms/notifications', 'APP-20190923-0000002', NULL),
	(19, '2019-11-07 17:27:21.486248', 'superuser', '2019-11-07 17:27:21.486290', 'superuser', 'MODULE-20191107-0000019', 'Delegation Management', 13, 'rms/delegation-management', 'APP-20190923-0000001', NULL),
	(20, '2020-03-19 11:43:06.231848', 'superuser', '2020-03-19 11:43:06.231891', 'superuser', 'MODULE-20200319-0000020', 'Asset Group', 2, 'ams/asset-groups', 'APP-20190923-0000003', NULL),
	(21, '2020-03-19 11:43:41.894134', 'superuser', '2020-03-19 11:43:41.894180', 'superuser', 'MODULE-20200319-0000021', 'Asset', 3, 'ams/assets', 'APP-20190923-0000003', NULL),
	(22, '2020-03-19 11:55:27.206147', 'superuser', '2020-03-19 11:55:27.206186', 'superuser', 'MODULE-20200319-0000022', 'Asset Stock', 4, 'ams/asset-stock', 'APP-20190923-0000003', NULL),
	(23, '2020-03-19 11:55:53.847177', 'superuser', '2020-03-19 11:55:53.847216', 'superuser', 'MODULE-20200319-0000023', 'Report', 5, 'ams/report', 'APP-20190923-0000003', NULL),
	(24, '2020-03-19 11:56:26.634991', 'superuser', '2020-03-19 11:56:26.635028', 'superuser', 'MODULE-20200319-0000024', 'Asset Type', 8, 'ams/asset-type-templates', 'APP-20190923-0000003', NULL),
	(25, '2020-03-19 11:56:46.268197', 'superuser', '2020-03-19 11:56:46.268234', 'superuser', 'MODULE-20200319-0000025', 'Report Type', 9, 'ams/report-type', 'APP-20190923-0000003', NULL);
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table rms_db.notifications
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `app` varchar(255) DEFAULT NULL,
  `notif_type` varchar(20) NOT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `sender_account_no` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `modified` datetime(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.notifications: ~0 rows (approximately)
DELETE FROM `notifications`;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;

-- Dumping structure for table rms_db.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `timeout_at` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.password_resets: ~0 rows (approximately)
DELETE FROM `password_resets`;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;

-- Dumping structure for table rms_db.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.permissions: ~0 rows (approximately)
DELETE FROM `permissions`;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.roles: ~0 rows (approximately)
DELETE FROM `roles`;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table rms_db.role_permissions
CREATE TABLE IF NOT EXISTS `role_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_permissions_permission_id_ad343843_fk_permissions_id` (`permission_id`),
  KEY `role_permissions_role_id_216516f2_fk_roles_id` (`role_id`),
  CONSTRAINT `role_permissions_permission_id_ad343843_fk_permissions_id` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`),
  CONSTRAINT `role_permissions_role_id_216516f2_fk_roles_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.role_permissions: ~0 rows (approximately)
DELETE FROM `role_permissions`;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.status_set
CREATE TABLE IF NOT EXISTS `status_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `ref` varchar(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(10) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.status_set: ~0 rows (approximately)
DELETE FROM `status_set`;
/*!40000 ALTER TABLE `status_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `status_set` ENABLE KEYS */;

-- Dumping structure for table rms_db.trigger_cancel
CREATE TABLE IF NOT EXISTS `trigger_cancel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `auto_cancel_date` datetime(6) DEFAULT NULL,
  `is_sent` tinyint(1) NOT NULL,
  `date_submitted_last_approver` datetime(6) DEFAULT NULL,
  `cancel_type` varchar(255) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `frm_approver_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `trigger_cancel_form_code_id_12248ad4_fk_change_re` (`form_code_id`),
  KEY `trigger_cancel_frm_approver_id_5878820c_fk_change_re` (`frm_approver_id`),
  CONSTRAINT `trigger_cancel_form_code_id_12248ad4_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `trigger_cancel_frm_approver_id_5878820c_fk_change_re` FOREIGN KEY (`frm_approver_id`) REFERENCES `change_request_form_approvers` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.trigger_cancel: ~0 rows (approximately)
DELETE FROM `trigger_cancel`;
/*!40000 ALTER TABLE `trigger_cancel` DISABLE KEYS */;
/*!40000 ALTER TABLE `trigger_cancel` ENABLE KEYS */;

-- Dumping structure for table rms_db.trigger_overdue
CREATE TABLE IF NOT EXISTS `trigger_overdue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `overdue_date` datetime(6) DEFAULT NULL,
  `is_sent` tinyint(1) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `trigger_overdue_form_code_id_934956d3_fk_change_re` (`form_code_id`),
  CONSTRAINT `trigger_overdue_form_code_id_934956d3_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.trigger_overdue: ~0 rows (approximately)
DELETE FROM `trigger_overdue`;
/*!40000 ALTER TABLE `trigger_overdue` DISABLE KEYS */;
/*!40000 ALTER TABLE `trigger_overdue` ENABLE KEYS */;

-- Dumping structure for table rms_db.trigger_reminder
CREATE TABLE IF NOT EXISTS `trigger_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `auto_cancel_date` datetime(6) DEFAULT NULL,
  `date_submitted_last_approver` datetime(6) DEFAULT NULL,
  `date_from` datetime(6) DEFAULT NULL,
  `date_to` datetime(6) DEFAULT NULL,
  `date_to_send` datetime(6) DEFAULT NULL,
  `is_sent` tinyint(1) NOT NULL,
  `form_code_id` varchar(255) DEFAULT NULL,
  `frm_approver_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `trigger_reminder_form_code_id_ebd56476_fk_change_re` (`form_code_id`),
  KEY `trigger_reminder_frm_approver_id_d1b7311b_fk_change_re` (`frm_approver_id`),
  CONSTRAINT `trigger_reminder_form_code_id_ebd56476_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `trigger_reminder_frm_approver_id_d1b7311b_fk_change_re` FOREIGN KEY (`frm_approver_id`) REFERENCES `change_request_form_approvers` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.trigger_reminder: ~1 rows (approximately)
DELETE FROM `trigger_reminder`;
/*!40000 ALTER TABLE `trigger_reminder` DISABLE KEYS */;
/*!40000 ALTER TABLE `trigger_reminder` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
